	subroutine vst(n,ndim,k,kdim,ddf,eps)
c**********************************************************************
c
c   FORTRAN subroutine to generate vector Student's t noise with 
c   degrees of freedom ddf.
c 
c   Input: n = an integer containing the number of observations.
c          ndim = an integer containing the number of rows of x in the
c                 calling routine.
c          k = an integer containing the number of components of the
c              realization.
c          kdim = an integer containing the number of rows of sigma
c                 in the calling routine.
c          ddf = a double precision scalar containing the degrees of
c                freedom.
c
c   Output: eps = a double precision matrix of dimension n x k containing
c                 the desired realization.
c
c   Subprograms called: (IMSL) DRNSTT
c
c   Written: 9/16/99 JLH
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
	integer n, ndim, k, kdim
	double precision ddf, eps(ndim,kdim)
c
c   Use IMSL subroutines.
c
	do i = 1,k
		call DRNSTT(n,ddf,eps(1,i))
	enddo
c
	return
	end